-- ======================= Update Country Code =============================================
SET SQL_SAFE_UPDATES = 0;
SET SQL_SAFE_UPDATES = 0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,\r\nT2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\r\nFROM `staffs` T1\r\nINNER JOIN `users` T2 ON T2.`id`=T1.`userId`\r\nINNER JOIN `persons` T3 ON T3.`id`=T1.`personId`\r\nLEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderId;

SET @dtproviderOwnerId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_OWNER_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,\r\nT2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\r\nFROM `staffs` T1\r\nINNER JOIN `users` T2 ON T2.`id`=T1.`userId`\r\nINNER JOIN `persons` T3 ON T3.`id`=T1.`personId`\r\nLEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderOwnerId;

SET @dtproviderSysId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SYSADMIN_DL');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,\r\nT2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\r\nFROM `staffs` T1\r\nINNER JOIN `users` T2 ON T2.`id`=T1.`userId`\r\nINNER JOIN `persons` T3 ON T3.`id`=T1.`personId`\r\nLEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderSysId;

SET @dtproviderStudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T1.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T3.`firstName` AS FIRST_NAME,\nT3.`middleName` AS MIDDLE_NAME,T3.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\nFROM admission T1\nINNER JOIN students T2 ON T2.userId=T1.studentId\nINNER JOIN `persons` T3 ON T3.id=T2.personId\nLEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\nWHERE T1.id IN (namedParams)" where `dataProviderId` = @dtproviderStudentId;

SET @dtproviderGuardianId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_GUARDIAN_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T3.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T3.`firstName` AS FIRST_NAME,\r\nT3.`middleName` AS MIDDLE_NAME,T3.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\r\nfrom `persons` T3 \r\n LEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T3.id IN (namedParams)" where `dataProviderId` = @dtproviderGuardianId;

SET @dtproviderRequesterId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_REQUESTER_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT\r\n        T2.id AS ID,\r\n        T5.`salutationName` AS SALUTATION_NAME,\r\n        T2.`firstName` AS FIRST_NAME,\r\n        T2.`middleName` AS MIDDLE_NAME,\r\n        T2.`lastName` AS LAST_NAME,\r\n        T3.`emailId` AS EMAIL_ID,\r\n        T3.`mobileNumber` AS MOBILE_NO ,\r\n T3.`mobileCountryCode` AS MOBILE_CODE,\r\nCASE WHEN T4.personId IS NULL THEN T1.personId ELSE T4.personID END \r\nFROM persons T3\r\nLEFT JOIN students T4 ON T3.id = T4.personId\r\nLEFT JOIN staffs T1 ON T3.id =T1.personId\r\nLEFT JOIN\r\n        `salutations` T5 \r\n            ON T5.`id`=T3.`salutationId`  \r\nLEFT JOIN users T2 ON ( T4.userId = T2.id OR T1.userId = T2.id ) \r\nWHERE \r\n  ( T4.userId = namedParams OR T1.userId = namedParams )" where `dataProviderId` = @dtproviderRequesterId;

SET @dtproviderCordinatorId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_RESOURCE_COORDINATOR_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,\r\nT2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO,T3.`mobileCountryCode` AS MOBILE_CODE\r\nFROM `staffs` T1\r\nINNER JOIN `users` T2 ON T2.`id`=T1.`userId`\r\nINNER JOIN `persons` T3 ON T3.`id`=T1.`personId`\r\n LEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderCordinatorId;

SET @dtproviderFacultyId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_FACULTY_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T3.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,\r\nT2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T2.`emailId` AS EMAIL_ID,T2.`mobileNumber` AS MOBILE_NO,T2.`mobileCountryCode` AS MOBILE_CODE\r\nFROM  staffs  T1\r\nINNER JOIN persons T2 ON T2.id=T1.personId\r\nLEFT JOIN salutations T3 ON T3.`id`=T2.salutationId\r\nWHERE T1.userId IN (namedParams)" where `dataProviderId` = @dtproviderFacultyId;

SET @dtproviderSponsorId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_SPONSOR_CONTACT_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T2.contactName AS CONTACT_NAME,T3.`primaryeEmailId` AS EMAIL_ID,T3.`cellNo` AS MOBILE_NO,T3.`cellCountryCode` AS MOBILE_CODE\r\nFROM `sponsors` T1\r\n LEFT JOIN `sponsor_contacts` T2 ON T2.sponsorId = T1.id\r\n LEFT JOIN address T3 ON T2.addressId=T3.id \r\nWHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderSponsorId;

SET @dtproviderApplicantId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T3.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,T2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T2.`emailId` AS EMAIL_ID,T2.`mobileNumber` AS MOBILE_NO,T2.`mobileCountryCode` AS MOBILE_CODE FROM `application`  T1 INNER JOIN `applicant_person` T2 ON T2.id = T1.applicantPersonId LEFT JOIN `salutations` T3 ON T3.`id`=T2.`salutationId` WHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderApplicantId;

SET @dtproviderStudentAttendanceId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_MSG_ATTENDANCE_STUDENT_CD');
update `sql_dtprovider` set `sqlQuery` = "SELECT T14.`id` AS ID,\nT5.`firstName` AS FIRST_NAME,\nT5.`middleName` AS MIDDLE_NAME,\nT5.`lastName` AS LAST_NAME,\nT6.`salutationName` AS SALUTATION,\nT2.`dateOfAttendance` AS DATE_OF_ATTENDANCE,\nT5.`emailId` AS EMAIL_ID,\nT5.`mobileNumber` AS MOBILE_NO,\nT5.`mobileCountryCode` AS MOBILE_CODE,\nREPLACE(CONCAT(SUBSTRING(T1.`attendanceStatus`,1,1),SUBSTRING(LOWER(T1.`attendanceStatus`),2)),\'_\',\' \') as ATTENDANCE_STATUS\nFROM `student_program_attendance_details` T1\nINNER JOIN `student_program_attendance` T2 ON T1.`attendanceId` = T2.`id`\nINNER JOIN `admission` T3 ON T3.`id` = T1.`admissionId`\nINNER JOIN `students` T4 ON T4.`userId` = T3.`studentId`\nINNER JOIN `persons` T5 ON T5.`id` = T4.`personId`\nINNER JOIN `users` T14 ON T14.`id` = T4.`userId`\nLEFT JOIN `salutations` T6 ON T5.`salutationId` = T6.`id`\nWHERE T14.`id` IN (namedParams)\nAND T2.`id` = (\nselect max(attendanceId) from `student_program_attendance_details` T9\nINNER JOIN `student_program_attendance` T10 ON T9.`attendanceId` = T10.`id`\nINNER JOIN `admission` T11 ON T11.`id` = T9.`admissionId`\nINNER JOIN `students` T12 ON T12.`userId` = T11.`studentId`\nINNER JOIN `persons` T13 ON T13.`id` = T12.`personId`\nINNER JOIN `users` T14 ON T14.`id` = T12.`userId`\nWHERE T14.`id` IN (namedParams))" where `dataProviderId` = @dtproviderStudentAttendanceId;

SET @dtproviderEnqId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_ENQUIRER_DTP');
update `sql_dtprovider` set `sqlQuery` = "select T1.`id` as ID, T1.`firstName` as FIRST_NAME, T1.`middleName` as MIDDLE_NAME, T1.`lastName` as LAST_NAME, T1.`primaryeEmailId` as EMAIL_ID, T1.`phoneNo` as MOBILE_NO, T1.`phoneCountryCode` AS MOBILE_CODE from `enquiry` T1 where T1.`id` IN (namedParams)" where `dataProviderId` = @dtproviderEnqId;

SET @dtproviderAttendanceStudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_ATTENDANCE_STUDENT_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "select\nT1.id as ID,\nT12.salutationName as STUDENT_SALUTATION,\nT1.firstName as STUDENT_FIRSTNAME,\nT1.lastName as STUDENT_LASTNAME,\nT13.salutationName as GUARDIAN_SALUTATION,\nT6.firstName as GUARDIAN_FIRSTNAME,\nT6.lastName as GUARDIAN_LASTNAME,\nT11.addressText as SWIPE_LOCATION,\nDATE_FORMAT(T4.punchTime,\'%b %d %Y %h:%i %p\') as PUNCH_TIME,\nT15.primaryeEmailId as EMAIL_ID,\nT15.cellNo as MOBILE_NO\n,\nT15.`cellCountryCode` AS MOBILE_CODE\nfrom persons T1\nINNER JOIN attendance_user_mapping T2 on T2.academiaUserId = T1.id\nINNER JOIN attendance_machine_user T3 on T3.userMappingId = T2.id\nINNER JOIN attendance_machine_log T4 on T4.attendanceMachineUserId = T3.id\nINNER JOIN attendance_machine_location T9 on T9.attendanceMachineId = T3.attendanceMachineId\n LEFT JOIN location_addresses T10 on T10.locationId = T9.locationId\n LEFT JOIN address T11 on T11.id = T10.addressId\n LEFT JOIN salutations T12 on T1.salutationId = T12.id\nINNER JOIN persons T6 on T6.id = ( \n	SELECT T7.relatedPersonId from person_relationships T7\n	where T7.relationship = \n		case\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship=\'LOCAL_GUARDIAN\') then \'LOCAL_GUARDIAN\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship=\'GUARDIAN\') then \'GUARDIAN\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship=\'FATHER\') then \'FATHER\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship=\'MOTHER\') then \'MOTHER\'\n		end\n)\n LEFT JOIN salutations T13 on T6.salutationId = T13.id\n LEFT JOIN person_addresses T14 on T14.personId = T6.id \n LEFT JOIN address T15 on T15.id = T14.addressId\nINNER JOIN (\nSELECT MAX(T20.id) MAXID from persons T17\n	INNER JOIN attendance_user_mapping T18 on T18.academiaUserId = T17.id\n	INNER JOIN attendance_machine_user T19 on T19.userMappingId = T18.id\n	INNER JOIN attendance_machine_log T20 on T20.attendanceMachineUserId = T19.id\nWHERE T17.id = (namedParams)\n)T16 on T4.id = T16.MAXID\nwhere T1.id =(namedParams) AND T14.whetherPrimary = 1" where `dataProviderId` = @dtproviderAttendanceStudentId;

SET @dtproviderApplicantParentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_PARENT_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT T3.id AS ID,T4.`salutationName` AS SALUTATION_NAME,T3.`firstName` AS FIRST_NAME,\r\nT3.`middleName` AS MIDDLE_NAME,T3.`lastName` AS LAST_NAME,T3.`emailId` AS EMAIL_ID,T3.`mobileNumber` AS MOBILE_NO\r\nFROM `application`  T1\r\nINNER JOIN `applicant_person_relationships` T2 ON T2.applicantPersonId = T1.applicantPersonId\r\nINNER JOIN `applicant_person` T3 ON T2.relatedApplicantPersonId = T3.id\r\n LEFT JOIN `salutations` T4 ON T4.`id`=T3.`salutationId`\r\nWHERE T3.id IN (namedParams)\r\nGROUP BY T3.id" where `dataProviderId` = @dtproviderApplicantParentId;

SET @dtproviderBillId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_MANUAL_BILL_GENERATION_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "SELECT\nT1.id AS ID,\nT4.`salutationName` AS SALUTATION_NAME,\nT2.`firstName` AS FIRST_NAME,\nT2.`middleName` AS MIDDLE_NAME,\nT2.`lastName` AS LAST_NAME,\nT2.`emailId` AS EMAIL_ID,\nT2.`mobileNumber` AS MOBILE_NO,\nT2.`mobileCountryCode` AS MOBILE_CODE,\nT1.`totalAmount` AS TOTAL_AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nT1.`billingDate` AS BILLING_DATE,\nT1.`billNo` AS BILL_NO,\nT1.`raiseBillCategory` AS RAISE_BILL_CATEGORY\nFROM bill_header T1\ninner join application T7 on T7.id=T1.applicantId\ninner join applicant_person T2 on T2.id = T7.applicantPersonId\n LEFT join salutations T4 on T4.id = T2.salutationId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.ID in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT4.`salutationName` AS SALUTATION_NAME,\nT3.`firstName` AS FIRST_NAME,\nT3.`middleName` AS MIDDLE_NAME,\nT3.`lastName` AS LAST_NAME,\nT3.`emailId` AS EMAIL_ID,\nT3.`mobileNumber` AS MOBILE_NO,\nT1.`totalAmount` AS TOTAL_AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nT1.`billingDate` AS BILLING_DATE,\nT1.`billNo` AS BILL_NO,\nT1.`raiseBillCategory` AS RAISE_BILL_CATEGORY\nFROM bill_header T1\ninner join students T2 ON T2.userId = T1.studentId\ninner join persons T3 on T3.id = T2.personId\n LEFT join salutations T4 on T4.id = T3.salutationId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.id in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT3.`contactName` AS SALUTATION_NAME,\nT2.`sponsorName` AS FIRST_NAME,\nT3.`designation` AS MIDDLE_NAME,\nT3.`designation` AS LAST_NAME,\nT4.`primaryeEmailId` AS EMAIL_ID,\nT4.`cellNo` AS MOBILE_NO,\nT1.`totalAmount` AS TOTAL_AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nT1.`billingDate` AS BILLING_DATE,\nT1.`billNo` AS BILL_NO,\nT1.`raiseBillCategory` AS RAISE_BILL_CATEGORY\nFROM bill_header T1\ninner join sponsors T2 ON T1.sponsorId = T2.id\ninner join sponsor_contacts T3 on T3.sponsorId = T2.id\ninner join address T4 on T4.id = T3.addressId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.ID in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT7.`salutationName` AS SALUTATION_NAME,\nT4.`firstName` AS FIRST_NAME,\nT4.`middleName` AS MIDDLE_NAME,\nT4.`lastName` AS LAST_NAME,\nT4.`emailId` AS EMAIL_ID,\nT4.`mobileNumber` AS MOBILE_NO,\nT1.`totalAmount` AS TOTAL_AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nT1.`billingDate` AS BILLING_DATE,\nT1.`billNo` AS BILL_NO,\nT1.`raiseBillCategory` AS RAISE_BILL_CATEGORY\nFROM bill_header T1\ninner join users T2 ON T1.userId = T2.id\ninner join staffs T3 ON T3.userId = T2.id\ninner join persons T4 on T4.id = T3.personId\ninner join currency T6 on T6.id = T1.currencyId\n LEFT join salutations T7 on T4.salutationId = T7.id\nWHERE T1.ID in (namedParams)" where `dataProviderId` = @dtproviderBillId;

SET @dtproviderEnqFollowerId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_FOLLOWER_DTP_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "select \nT1.`id` as ID, \nT3.`firstName` as FIRST_NAME, \nT3.`middleName` as MIDDLE_NAME, \nT3.`lastName` as LAST_NAME,\nT3.`emailId` as EMAIL_ID, \nT3.`mobileNumber` as MOBILE_NO,\nT3.`mobileCountryCode` AS MOBILE_CODE,\nT5.`code` as ENQUIRY_CODE\nfrom users T1\ninner join staffs T2 on T2.userId = T1.id\ninner join persons T3 on T3.id = T2.personId\ninner join enq_followup T4 on T4.assignTo = T1.id\nleft join enquiry T5 on T5.id = T4.enquiryId\nwhere T1.id in (namedParams)\norder by T4.id DESC LIMIT 1" where `dataProviderId` = @dtproviderEnqFollowerId;

SET @dtproviderWeeklyId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_WEEKLY_ATTENDANCE_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "select \ntmp1.ID as ID,\ntmp1.TOTAL_PRESENT as `TOTAL_PRESENT`,\ntmp1.TOTAL_ABSENT as `TOTAL_ABSENT`,\ntmp1.PRESENT_PERCENTAGE as `PRESENT_PERCENTAGE`,\ntmp1.ABSENT_PERCENTAGE as `ABSENT_PERCENTAGE`,\ntmp1.FIRST_NAME as `FIRST_NAME`,\ntmp1.LAST_NAME as `LAST_NAME`,\ntmp1.MOBILE_NO as `MOBILE_NO`,\ntmp1.MOBILE_CODE as `MOBILE_CODE`,\ntmp1.EMAIL_ID as `EMAIL_ID`,\nIFNULL(tmp2.DATE, DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')) as `DATE1`,\nIF(tmp2.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp2.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp2.DATEDETAILS),2)),\'_\',\' \')) as `DATE1DETAILS`,\nIFNULL(tmp3.DATE, DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')) as `DATE2`,\nIF(tmp3.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp3.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp3.DATEDETAILS),2)),\'_\',\' \')) as `DATE2DETAILS`,\nIFNULL(tmp4.DATE, DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')) as `DATE3`,\nIF(tmp4.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp4.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp4.DATEDETAILS),2)),\'_\',\' \')) as `DATE3DETAILS`,\nIFNULL(tmp5.DATE, DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')) as `DATE4`,\nIF(tmp5.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp5.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp5.DATEDETAILS),2)),\'_\',\' \')) as `DATE4DETAILS`,\nIFNULL(tmp6.DATE, DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')) as `DATE5`,\nIF(tmp6.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp6.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp6.DATEDETAILS),2)),\'_\',\' \')) as `DATE5DETAILS`,\nIFNULL(tmp7.DATE, DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')) as `DATE6`,\nIF(tmp7.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp7.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp7.DATEDETAILS),2)),\'_\',\' \')) as `DATE6DETAILS`,\nIFNULL(tmp8.DATE, DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')) as `DATE7`,\nIF(tmp8.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp8.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp8.DATEDETAILS),2)),\'_\',\' \')) as `DATE7DETAILS`\nfrom \n(\nselect T3.studentId as `ID`,\ncount(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,\ncount(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,\nROUND((count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))/\n	(count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))\n    +count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,\nROUND((count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))/\n	(count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))\n    +count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,\nT5.firstName as `FIRST_NAME`,\nT5.lastName as `LAST_NAME`,\nT5.mobileNumber as `MOBILE_NO`,\nT5.mobileCountryCode as `MOBILE_CODE`,\nT5.emailId as `EMAIL_ID`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),\'%Y-%m-%d\') AND DATE_FORMAT(NOW(),\'%Y-%m-%d\'))\ngroup by T3.studentId\norder by T3.studentId\n) tmp1\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp2 on tmp2.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp3 on tmp3.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp4 on tmp4.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp5 on tmp5.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp6 on tmp6.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp7 on tmp7.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp8 on tmp8.studentId = tmp1.`ID`" where `dataProviderId` = @dtproviderWeeklyId;

SET @dtproviderWeeklyParentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_WEEKLY_ATTENDANCE_PARENTS_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "select \ntmp1.ID as ID,\ntmp1.TOTAL_PRESENT as `TOTAL_PRESENT`,\ntmp1.TOTAL_ABSENT as `TOTAL_ABSENT`,\ntmp1.PRESENT_PERCENTAGE as `PRESENT_PERCENTAGE`,\ntmp1.ABSENT_PERCENTAGE as `ABSENT_PERCENTAGE`,\ntmp1.FIRST_NAME as `FIRST_NAME`,\ntmp1.LAST_NAME as `LAST_NAME`,\ntmp1.MOBILE_NO as `MOBILE_NO`,\ntmp1.EMAIL_ID as `EMAIL_ID`,\ntmp1.MOBILE_CODE as `MOBILE_CODE`,\nIFNULL(tmp2.DATE, DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')) as `DATE1`,\nIF(tmp2.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp2.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp2.DATEDETAILS),2)),\'_\',\' \')) as `DATE1DETAILS`,\nIFNULL(tmp3.DATE, DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')) as `DATE2`,\nIF(tmp3.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp3.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp3.DATEDETAILS),2)),\'_\',\' \')) as `DATE2DETAILS`,\nIFNULL(tmp4.DATE, DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')) as `DATE3`,\nIF(tmp4.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp4.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp4.DATEDETAILS),2)),\'_\',\' \')) as `DATE3DETAILS`,\nIFNULL(tmp5.DATE, DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')) as `DATE4`,\nIF(tmp5.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp5.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp5.DATEDETAILS),2)),\'_\',\' \')) as `DATE4DETAILS`,\nIFNULL(tmp6.DATE, DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')) as `DATE5`,\nIF(tmp6.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp6.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp6.DATEDETAILS),2)),\'_\',\' \')) as `DATE5DETAILS`,\nIFNULL(tmp7.DATE, DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')) as `DATE6`,\nIF(tmp7.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp7.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp7.DATEDETAILS),2)),\'_\',\' \')) as `DATE6DETAILS`,\nIFNULL(tmp8.DATE, DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')) as `DATE7`,\nIF(tmp8.DATEDETAILS IS NULL , \'-\', REPLACE(CONCAT(SUBSTRING(tmp8.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp8.DATEDETAILS),2)),\'_\',\' \')) as `DATE7DETAILS`\nfrom \n(\nselect T3.studentId as `ID`,\ncount(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,\ncount(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,\nROUND((count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))/\n	(count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))\n    +count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,\nROUND((count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))/\n	(count(IF(T2.attendanceStatus = \'PRESENT\',T2.attendanceStatus,null))\n    +count(IF(T2.attendanceStatus <> \'PRESENT\',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,\nT6.firstName as `FIRST_NAME`,\nT6.lastName as `LAST_NAME`,\nT6.mobileNumber as `MOBILE_NO`,\nT6.mobileCountryCode as `MOBILE_CODE`,\nT6.emailId as `EMAIL_ID`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId \ninner join persons T6 on T6.id =\n( \n	SELECT T7.relatedPersonId from person_relationships T7\n	where T7.personId = T5.id AND T7.relationship = \n		case\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship=\'LOCAL_GUARDIAN\') then \'LOCAL_GUARDIAN\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship=\'GUARDIAN\') then \'GUARDIAN\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship=\'FATHER\') then \'FATHER\'\n			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship=\'MOTHER\') then \'MOTHER\'\n		end\n)\nwhere T3.studentId in (namedParams)\nand (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),\'%Y-%m-%d\') AND DATE_FORMAT(NOW(),\'%Y-%m-%d\'))\ngroup by T3.studentId\norder by T3.studentId\n) tmp1\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),7),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp2 on tmp2.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),6),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp3 on tmp3.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),5),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp4 on tmp4.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),4),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp5 on tmp5.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),3),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp6 on tmp6.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),2),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp7 on tmp7.studentId = tmp1.`ID`\nleft join (\nselect T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')) as `DATE`,\nIFNULL(T2.attendanceStatus , \'-\') as `DATEDETAILS`\nfrom student_program_attendance T1\ninner join student_program_attendance_details T2 on T2.attendanceId = T1.id\ninner join admission T3 on T3.id = T2.admissionId\ninner join students T4 on T4.userId = T3.studentId\ninner join persons T5 on T5.id = T4.personId\nwhere T3.studentId in (namedParams)\nand dateOfAttendance = DATE_FORMAT(subdate(now(),1),\'%Y-%m-%d\')\ngroup by T3.studentId \norder by T3.studentId\n) tmp8 on tmp8.studentId = tmp1.`ID`" where `dataProviderId` = @dtproviderWeeklyParentId;

SET @dtproviderMannualRcptId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_MANUAL_RECEIPT_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "SELECT\nT1.id AS ID,\nT4.`salutationName` AS SALUTATION_NAME,\nT2.`firstName` AS FIRST_NAME,\nT2.`middleName` AS MIDDLE_NAME,\nT2.`lastName` AS LAST_NAME,\nT2.`emailId` AS EMAIL_ID,\nT2.`mobileNumber` AS MOBILE_NO,\nT2.`mobileCountryCode` AS MOBILE_CODE,\nT1.`amount` AS AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nCONCAT(SUBSTRING(T1.`transactionDate`,9,2),\'-\',SUBSTRING(T1.`transactionDate`,6,2),\'-\',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,\nT1.`receiptNo` AS RECEIPT_NO,\n(CASE\n	WHEN (T1.`status` = \'FULLY_PENDING\') \n		THEN \'Fully pending\'\n	WHEN (T1.`status` = \'PARTLY_SETTLED\') \n		THEN \'Partly settled\'\n	WHEN (T1.`status` = \'SETTLED\') \n		THEN \'Settled\'\n	WHEN (T1.`status` = \'CANCELLED\') \n		THEN \'Cancelled\'\n	WHEN (T1.`status` = \'REVERSED\') \n		THEN \'Reversed\'\nEND) AS STATUS\nFROM receipt_header T1\ninner join application T7 on T7.id=T1.applicantId\ninner join applicant_person T2 on T2.id = T7.applicantPersonId\n LEFT join salutations T4 on T4.id = T2.salutationId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.ID in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT4.`salutationName` AS SALUTATION_NAME,\nT3.`firstName` AS FIRST_NAME,\nT3.`middleName` AS MIDDLE_NAME,\nT3.`lastName` AS LAST_NAME,\nT3.`emailId` AS EMAIL_ID,\nT3.`mobileNumber` AS MOBILE_NO,\nT3.`mobileCountryCode` AS MOBILE_CODE,\nT1.`amount` AS AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nCONCAT(SUBSTRING(T1.`transactionDate`,9,2),\'-\',SUBSTRING(T1.`transactionDate`,6,2),\'-\',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,\nT1.`receiptNo` AS RECEIPT_NO,\n(CASE\n	WHEN (T1.`status` = \'FULLY_PENDING\') \n		THEN \'Fully pending\'\n	WHEN (T1.`status` = \'PARTLY_SETTLED\') \n		THEN \'Partly settled\'\n	WHEN (T1.`status` = \'SETTLED\') \n		THEN \'Settled\'\n	WHEN (T1.`status` = \'CANCELLED\') \n		THEN \'Cancelled\'\n	WHEN (T1.`status` = \'REVERSED\') \n		THEN \'Reversed\'\nEND) AS STATUS\nFROM receipt_header T1\ninner join students T2 ON T2.userId = T1.studentId\ninner join persons T3 on T3.id = T2.personId\n LEFT join salutations T4 on T4.id = T3.salutationId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.id in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT3.`contactName` AS SALUTATION_NAME,\nT2.`sponsorName` AS FIRST_NAME,\nT3.`designation` AS MIDDLE_NAME,\nT3.`designation` AS LAST_NAME,\nT4.`primaryeEmailId` AS EMAIL_ID,\nT4.`cellNo` AS MOBILE_NO,\nT4.`cellCountryCode` AS MOBILE_CODE,\nT1.`amount` AS AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nCONCAT(SUBSTRING(T1.`transactionDate`,9,2),\'-\',SUBSTRING(T1.`transactionDate`,6,2),\'-\',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,\nT1.`receiptNo` AS RECEIPT_NO,\n(CASE\n	WHEN (T1.`status` = \'FULLY_PENDING\') \n		THEN \'Fully pending\'\n	WHEN (T1.`status` = \'PARTLY_SETTLED\') \n		THEN \'Partly settled\'\n	WHEN (T1.`status` = \'SETTLED\') \n		THEN \'Settled\'\n	WHEN (T1.`status` = \'CANCELLED\') \n		THEN \'Cancelled\'\n	WHEN (T1.`status` = \'REVERSED\') \n		THEN \'Reversed\'\nEND) AS STATUS\nFROM receipt_header T1\ninner join sponsors T2 ON T1.sponsorId = T2.id\ninner join sponsor_contacts T3 on T3.sponsorId = T2.id\ninner join address T4 on T4.id = T3.addressId\ninner join currency T6 on T6.id = T1.currencyId\nWHERE T1.ID in (namedParams)\nUNION\nSELECT\nT1.id AS ID,\nT7.`salutationName` AS SALUTATION_NAME,\nT4.`firstName` AS FIRST_NAME,\nT4.`middleName` AS MIDDLE_NAME,\nT4.`lastName` AS LAST_NAME,\nT4.`emailId` AS EMAIL_ID,\nT4.`mobileNumber` AS MOBILE_NO,\nT4.`mobileCountryCode` AS MOBILE_CODE,\nT1.`amount` AS AMOUNT,\nT6.`currencyCode` AS CURRENCY_CODE,\nCONCAT(SUBSTRING(T1.`transactionDate`,9,2),\'-\',SUBSTRING(T1.`transactionDate`,6,2),\'-\',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,\nT1.`receiptNo` AS RECEIPT_NO,\n(CASE\n	WHEN (T1.`status` = \'FULLY_PENDING\') \n		THEN \'Fully pending\'\n	WHEN (T1.`status` = \'PARTLY_SETTLED\') \n		THEN \'Partly settled\'\n	WHEN (T1.`status` = \'SETTLED\') \n		THEN \'Settled\'\n	WHEN (T1.`status` = \'CANCELLED\') \n		THEN \'Cancelled\'\n	WHEN (T1.`status` = \'REVERSED\') \n		THEN \'Reversed\'\nEND) AS STATUS\nFROM receipt_header T1\ninner join users T2 ON T1.userId = T2.id\ninner join staffs T3 ON T3.userId = T2.id\ninner join persons T4 on T4.id = T3.personId\ninner join currency T6 on T6.id = T1.currencyId\n LEFT join salutations T7 on T4.salutationId = T7.id\nWHERE T1.ID in (namedParams)" where `dataProviderId` = @dtproviderMannualRcptId;

SET @dtproviderBirthId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE from\n(\n	select \n		userId as ID,\n        p.birthDate as BIRTH_DATE,\n        sal.salutationName as SALUTATION_NAME,\n        p.firstName as FIRST_NAME,\n        p.middleName as MIDDLE_NAME,\n        p.lastName as LAST_NAME,\n        p.emailId as EMAIL_ID,\n        p.mobileNumber as MOBILE_NO,\n        p.mobileCountryCode as MOBILE_CODE\n	from \n		students s\n		inner join users u on u.id = s.userId\n		inner join persons p on p.id = s.personId\n		LEFT join salutations sal on sal.id = p.salutationId\n	UNION\n	select \n		userId as ID,\n        p.birthDate as BIRTH_DATE,\n        sal.salutationName as SALUTATION_NAME,\n        p.firstName as FIRST_NAME,\n        p.middleName as MIDDLE_NAME,\n        p.lastName as MIDDLE_NAME,\n        p.emailId as EMAIL_ID,\n        p.mobileNumber as MOBILE_NO,\n        p.mobileCountryCode as MOBILE_CODE\n	from \n		staffs s\n		inner join users u on u.id = s.userId\n		inner join persons p on p.id = s.personId\n		left join salutations sal on sal.id = p.salutationId\n) as PSEUDO\nwhere date_format(BIRTH_DATE,\'%m-%d\') = date_format(now(),\'%m-%d\')\nand id in (namedParams)" where `dataProviderId` = @dtproviderBirthId;

SET @dtproviderLimeFacId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_FAC_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T4.`salutationName` AS SALUTATION_NAME,\n	T3.`firstName` AS FIRST_NAME,\n	T3.`middleName` AS MIDDLE_NAME,\n	T3.`lastName` AS LAST_NAME,\n	T3.`emailId` AS EMAIL_ID,\n	T3.`mobileNumber` AS MOBILE_NO,\n	T1.`surveyUrl` AS SURVEY_URL,\n	T3.`mobileCountryCode` AS MOBILE_CODE\n	from survey_participant_info T1 \n	left outer join staffs T2 on T1.userId=T2.userId\n	left outer join persons T3 on T2.personId=T3.id\n    left join salutations T4 on T4.id = T3.salutationId\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderLimeFacId;

SET @dtproviderLimeStuId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_STU_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T4.`salutationName` AS SALUTATION_NAME,\n	T3.`firstName` AS FIRST_NAME,\n	T3.`middleName` AS MIDDLE_NAME,\n	T3.`lastName` AS LAST_NAME,\n	T3.`emailId` AS EMAIL_ID,\n	T3.`mobileNumber` AS MOBILE_NO,\n	T1.`surveyUrl` AS SURVEY_URL,\n	T3.`mobileCountryCode` AS MOBILE_CODE\n	from survey_participant_info T1 \n	left outer join students T2 on T1.studentId=T2.userId\n    left outer join persons T3 on T2.personId=T3.id \n    left join salutations T4 on T4.id = T3.salutationId\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderLimeStuId;

SET @dtproviderLimeAppId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_APP_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T4.`salutationName` AS SALUTATION_NAME,\n	T3.`firstName` AS FIRST_NAME,\n	T3.`middleName` AS MIDDLE_NAME,\n	T3.`lastName` AS LAST_NAME,\n	T3.`emailId` AS EMAIL_ID,\n	T3.`mobileNumber` AS MOBILE_NO,\n	T1.`surveyUrl` AS SURVEY_URL,\n	T3.`mobileCountryCode` AS MOBILE_CODE\n	from survey_participant_info T1 \n	left outer join application T2 on T1.applicantId=T2.id\n    left outer join applicant_person T3 on T2.applicantPersonId=T3.id \n    left join salutations T4 on T4.id = T3.salutationId\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderLimeAppId;

SET @dtproviderLimeEnqId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_ENQ_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T2.`firstName` AS FIRST_NAME,\n	T2.`middleName` AS MIDDLE_NAME,\n	T2.`lastName` AS LAST_NAME,\n	T4.`primaryeEmailId` AS EMAIL_ID,\n	T4.`cellNo` AS MOBILE_NO,\n	T1.`surveyUrl` AS SURVEY_URL,\n	T4.`cellCountryCode` AS MOBILE_CODE\n    from survey_participant_info T1 \n	left outer join enquiry T2 on T1.enquiryId=T2.id\n    left outer join enq_address T3 on T2.id=T3.enquiryId \n    left outer join address T4 on T3.addressId=T4.id\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderLimeEnqId;

SET @dtproviderExtUserId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_RECIPIENT_INFO');
update `sql_dtprovider` set `sqlQuery` = "select T1.id as ID,\n	T4.`firstName` AS FIRST_NAME,\n	T4.`lastName` AS LAST_NAME,\n    T4.`emailId` AS EMAIL_ID,\n	T4.`mobileNumber` AS MOBILE_NO,\n	T4.`mobileCountryCode` AS MOBILE_CODE\n from external_users T1\n	left join external_user_association T2 on T2.externalUserId=T1.id\n    left join application T3 on T3.id=T2.applicationId\n    left join applicant_person T4 on T4.id=T3.applicantPersonId \n    where T1.id in (namedParams)" where `dataProviderId` = @dtproviderExtUserId;

SET @dtproviderAppRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T3.`salutationName` AS SALUTATION_NAME,\n	T2.`firstName` AS FIRST_NAME,\n	T2.`middleName` AS MIDDLE_NAME,\n	T2.`lastName` AS LAST_NAME,\n	T2.`emailId` AS EMAIL_ID,\n	T2.`mobileNumber` AS MOBILE_NO,\n    T1.`code` as APPLICATION_CODE,\n	T2.`mobileCountryCode` AS MOBILE_CODE\n    from application T1 \n    left outer join applicant_person T2 on T1.applicantPersonId=T2.id\n    left join salutations T3 on T3.id = T2.salutationId\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderAppRecId;

SET @dtproviderRejectId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "select T1.id AS ID,\n	T3.`salutationName` AS SALUTATION_NAME,\n	T2.`firstName` AS FIRST_NAME,\n	T2.`middleName` AS MIDDLE_NAME,\n	T2.`lastName` AS LAST_NAME,\n	T2.`emailId` AS EMAIL_ID,\n	T2.`mobileNumber` AS MOBILE_NO,\n    T1.`code` as APPLICATION_CODE,\n	T2.`mobileCountryCode` AS MOBILE_CODE\n    from application T1 \n    left outer join applicant_person T2 on T1.applicantPersonId=T2.id\n    LEFT join salutations T3 on T3.id = T2.salutationId\n    where T1.id in(namedParams)" where `dataProviderId` = @dtproviderRejectId;

SET @dtproviderAdmAppId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_ADMISSION_APPLICANT_INFO');
update `sql_dtprovider` set `sqlQuery` = "SELECT T2.id AS ID,T3.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,T2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T2.`emailId` AS EMAIL_ID,T2.`mobileNumber` AS MOBILE_NO,T2.`mobileCountryCode` AS MOBILE_CODE FROM `application`  T1 INNER JOIN `applicant_person` T2 ON T2.id = T1.applicantPersonId LEFT JOIN `salutations` T3 ON T3.`id`=T2.`salutationId` WHERE T2.id IN (namedParams)" where `dataProviderId` = @dtproviderAdmAppId;

SET @dtproviderUserForgetId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO');
update `sql_dtprovider` set `sqlQuery` = "select T1.id as ID,\n	T4.`firstName` AS FIRST_NAME,\n	T4.`lastName` AS LAST_NAME,\n    T4.`emailId` AS EMAIL_ID,\n	T4.`mobileNumber` AS MOBILE_NO,\n	T4.`mobileCountryCode` AS MOBILE_CODE\n 	from external_users T1\n	left join external_user_association T2 on T2.externalUserId=T1.id\n    left join application T3 on T3.id=T2.applicationId\n    left join applicant_person T4 on T4.id=T3.applicantPersonId \n    where T1.id in (namedParams)" where `dataProviderId` = @dtproviderUserForgetId;

SET @dtproviderAppAdhocId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_ADHOC');
update `sql_dtprovider` set `sqlQuery` = "SELECT T1.id AS ID,T3.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,T2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T2.`emailId` AS EMAIL_ID,T2.`mobileNumber` AS MOBILE_NO,T2.`mobileCountryCode` AS MOBILE_CODE FROM `application`  T1 INNER JOIN `applicant_person` T2 ON T2.id = T1.applicantPersonId LEFT JOIN `salutations` T3 ON T3.`id`=T2.`salutationId` WHERE T1.id IN (namedParams)" where `dataProviderId` = @dtproviderAppAdhocId;

SET @dtproviderAcademyLocId=(SELECT id FROM dtprovider WHERE `dataProviderName`='Academy_Location_Expiry_Rcpnt');
update `sql_dtprovider` set `sqlQuery` = "select \n    T1.`id` AS ID,\n    T4.`emailId` AS EMAIL_ID,\n    T4.`firstName` AS FIRST_NAME,\n	T4.`lastName` AS LAST_NAME,\n	T4.`mobileNumber` AS MOBILE_NO,\n    DATEDIFF(date_format(T1.tillDate,\'%Y-%m-%d\'),date_format(now(),\'%Y-%m-%d\')) AS DAYS_TO_EXPIRE,\n    T1.tillDate AS EXPIRY_DATE,\n    T5.locationName AS LOCATION_NAME,\n    T5.academyName AS ACADEMY_NAME,\n    T5.locationCode AS LOCATION_CODE,\n	T4.`mobileCountryCode` AS MOBILE_CODE\n    from academy_location_purpose T1\n		left outer join users T2 on T1.ownerId=T2.id\n        left outer join staffs T3 on T3.userId=T2.id\n        left outer join persons T4 on T3.personId=T4.id\n        left outer join academy_location T5 on T1.academyLocationId=T5.id\n        where T1.id in (namedParams) and T1.purposeCode=\'COURSE_EXECUTION\'" where `dataProviderId` = @dtproviderAcademyLocId;

SET @dtproviderTimeTablecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_CHANGE_RECIPIENT_INFO');
update `sql_dtprovider` set `sqlQuery` = "select T1.userId as ID,\n	T2.`firstName` AS FIRST_NAME,\n	T2.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n	T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\n from students T1\n	left join persons T2 on T1.personId=T2.id \n    where T1.userId in (namedParams)" where `dataProviderId` = @dtproviderTimeTablecId;

SET @dtproviderAppLoginId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_LOGIN_CREDENTIAL_INFO');
update `sql_dtprovider` set `sqlQuery` = "select T1.id as ID,\n	T4.`firstName` AS FIRST_NAME,\n	T4.`lastName` AS LAST_NAME,\n    T4.`emailId` AS EMAIL_ID,\n	T4.`mobileNumber` AS MOBILE_NO,\n	T4.`mobileCountryCode` AS MOBILE_CODE\n from external_users T1\n	left join external_user_association T2 on T2.externalUserId=T1.id\n    left join application T3 on T3.id=T2.applicationId\n    left join applicant_person T4 on T4.id=T3.applicantPersonId \n    where T1.id in (namedParams)" where `dataProviderId` = @dtproviderAppLoginId;

SET @dtproviderAcademyLocPurId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_PURPOSE_OWNER');
update `sql_dtprovider` set `sqlQuery` = "select \n    T1.`id` AS ID,\n    T4.`emailId` AS EMAIL_ID,\n    T4.`firstName` AS FIRST_NAME,\n	T4.`lastName` AS LAST_NAME,\n	T4.`mobileNumber` AS MOBILE_NO,\n    DATEDIFF(date_format(T1.tillDate,\'%Y-%m-%d\'),date_format(now(),\'%Y-%m-%d\')) AS DAYS_TO_EXPIRE,\n    T1.tillDate AS EXPIRY_DATE,\n    T5.locationName AS LOCATION_NAME,\n    T5.academyName AS ACADEMY_NAME,\n    T5.locationCode AS LOCATION_CODE,\n	T4.`mobileCountryCode` AS MOBILE_CODE\n    from academy_location_purpose T1\n		left outer join users T2 on T1.ownerId=T2.id\n        left outer join staffs T3 on T3.userId=T2.id\n        left outer join persons T4 on T3.personId=T4.id\n        left outer join academy_location T5 on T1.academyLocationId=T5.id\n        where T1.id in (namedParams)" where `dataProviderId` = @dtproviderAcademyLocPurId;

SET @dtproviderParentTypId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T2.id AS ID,\n    T4.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T3.`emailId` AS EMAIL_ID,\n    T3.`mobileNumber` AS MOBILE_NO,\n	T3.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `parents` T1\n        INNER JOIN\n    `users` T2 ON T2.`id` = T1.`userId`\n        INNER JOIN\n    `persons` T3 ON T3.`id` = T1.`personId`\n        LEFT JOIN\n    `salutations` T4 ON T4.`id` = T3.`salutationId`\nWHERE\n    T2.id IN (namedParams)" where `dataProviderId` = @dtproviderParentTypId;

SET @dtproviderStuTypeId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T2.id AS ID,\n    T4.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T3.`emailId` AS EMAIL_ID,\n    T3.`mobileNumber` AS MOBILE_NO,\n	T3.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `students` T1\n        INNER JOIN\n    `users` T2 ON T2.`id` = T1.`userId`\n        INNER JOIN\n    `persons` T3 ON T3.`id` = T1.`personId`\n        LEFT JOIN\n    `salutations` T4 ON T4.`id` = T3.`salutationId`\nWHERE\n    T2.id IN (namedParams)" where `dataProviderId` = @dtproviderStuTypeId;

SET @dtproviderUserUpdateId=(SELECT id FROM dtprovider WHERE `dataProviderName`='USER_UPDATE_RECIPIENT');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE	\nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderUserUpdateId;

SET @dtproviderResetPassId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RESET_PASSWORD_RECIPIENT');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n    LEFT JOIN\n	`students` T4 on T4.`userId`=T1.`id`\n	LEFT JOIN\n	`staffs` T5 on T5.`userId`=T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId` or T2.`id` = T5.`personId`	\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T4.userId IN (namedParams) or T5.userId IN(namedParams)" where `dataProviderId` = @dtproviderResetPassId;

SET @dtproviderResetAppId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_RESET_PASSWORD_RECIPIENT');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T5.`salutationName` AS SALUTATION_NAME,\n    T4.`firstName` AS FIRST_NAME,\n    T4.`middleName` AS MIDDLE_NAME,\n    T4.`lastName` AS LAST_NAME,\n    T4.`emailId` AS EMAIL_ID,\n    T4.`mobileNumber` AS MOBILE_NO,\n	T4.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `external_users` T1 \n        INNER JOIN\n	`external_user_association` T2 ON T2.`externalUserId` =T1.`id`\n		LEFT JOIN\n    `application` T3 ON T3.`id` = T2.`applicationId`\n		LEFT JOIN\n    `applicant_person` T4 ON T4.`id` = T3.`applicantPersonId`\n        LEFT JOIN\n    `salutations` T5 ON T5.`id` = T4.`salutationId`\nWHERE\n    T1.id IN(namedParams)" where `dataProviderId` = @dtproviderResetAppId;

SET @dtproviderFacAdhocId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FACULTY_ADHOC');
update `sql_dtprovider` set `sqlQuery` = "SELECT T1.userId AS ID,T3.`salutationName` AS SALUTATION_NAME,T2.`firstName` AS FIRST_NAME,T2.`middleName` AS MIDDLE_NAME,T2.`lastName` AS LAST_NAME,T2.`emailId` AS EMAIL_ID,T2.`mobileNumber` AS MOBILE_NO,T2.`mobileCountryCode` AS MOBILE_CODE FROM  staffs  T1 INNER JOIN persons T2 ON T2.id=T1.personId LEFT JOIN salutations T3 ON T3.`id`=T2.salutationId WHERE T1.userId IN (namedParams)" where `dataProviderId` = @dtproviderFacAdhocId;

SET @dtproviderCommitteeId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_COMMITTEE');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE	\nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderCommitteeId;

SET @dtproviderCommitteeAdhocId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COMMITTEE_ADHOC');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO	\nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO\nFROM\n    `users` T1 \n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO\nFROM\n    `users` T1 \n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderCommitteeAdhocId;

SET @dtproviderParenResetPassId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PARENT_RESET_PASSWORD_RECIPIENT');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n    LEFT JOIN\n	`parents` T4 on T4.`userId`=T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`	\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T4.userId IN (namedParams)" where `dataProviderId` = @dtproviderParenResetPassId;

SET @dtproviderMeetingId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_MEETING_MEMBER_DTP');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE    \nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\n    LEFT JOIN \n	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId\nWHERE\n    T5.id IN (namedParams)\nUNION\nSELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\n     LEFT JOIN \n	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId\nWHERE\n    T5.id IN (namedParams)\n\nUNION\nSELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\n     LEFT JOIN \n	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId\nWHERE\n    T5.id IN (namedParams)" where `dataProviderId` = @dtproviderMeetingId;

SET @dtproviderTaskId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COMMITTEE_TASK_RCPNT');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T5.status AS STATUS,\n    T5.type AS MINUTE_TYPE,\n    T5.dueDate AS DUE_DATE,\n    T5.assignDate AS ASSIGN_DATE,\n    T5.completionDate AS COMPLETION_DATE,\n    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,\n	T2.`mobileCountryCode` AS MOBILE_CODE\n	\nFROM\n    event_meeting_minutes_task T5 \n    INNER JOIN\n    `users` T1 ON  T1.id = T5.ownerId\n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T5.id IN (namedParams)\n\nUNION\nSELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T5.status AS STATUS,\n    T5.type AS MINUTE_TYPE,\n    T5.dueDate AS DUE_DATE,\n    T5.assignDate AS ASSIGN_DATE,\n    T5.completionDate AS COMPLETION_DATE,\n    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    event_meeting_minutes_task T5 \n    INNER JOIN\n    `users` T1 ON  T1.id = T5.ownerId\n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T5.id IN (namedParams)\n\nUNION\nSELECT \n    T5.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T5.status AS STATUS,\n    T5.type AS MINUTE_TYPE,\n    T5.dueDate AS DUE_DATE,\n    T5.assignDate AS ASSIGN_DATE,\n    T5.completionDate AS COMPLETION_DATE,\n    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n	event_meeting_minutes_task T5 \n    INNER JOIN\n    `users` T1 ON  T1.id = T5.ownerId\n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`    \nWHERE\n    T5.id IN (namedParams)" where `dataProviderId` = @dtproviderTaskId;

SET @dtproviderResourceId=(SELECT id FROM dtprovider WHERE `dataProviderName`='Resource Participant Recipient');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE	\nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`students` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)\n\nUNION\nSELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE\nFROM\n    `users` T1 \n	INNER JOIN\n	`parents` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderResourceId;

SET @dtproviderParticipantId=(SELECT id FROM dtprovider WHERE `dataProviderName`='Task Participant Recipient');
update `sql_dtprovider` set `sqlQuery` = "SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n	T2.`mobileCountryCode` AS MOBILE_CODE	\nFROM\n    `users` T1 \n	INNER JOIN\n	`staffs` T4 ON T4.`userId` = T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderParticipantId;


-- for Enquiry Follow Up SIN
update msg_template_config set msgMessageTypeId = 4 where code = 'MSG_ENQUIRY_FOLLOW_UP_TEMPLATE';


-- Added Followup template for velocity 
INSERT INTO `msg_template_config` (`code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigName`, `approvalRequired`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) VALUES ('Enquiry Follow-up Velocity', '47', '29', '18', '4', '28', 'Enquiry Follow-up Velocity', 0, 0, 'APPROVED', 0, '1', 'System Admin System Admin', '1');

SET @msgTemplateConfigId=(SELECT id FROM `msg_template_config` WHERE code='Enquiry Follow-up Velocity');
INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES (@msgTemplateConfigId, '4', 'Enquiry Follow Up Assignment', '<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Follow-up to Enquiry No.&nbsp;$recipientData[&quot;ENQUIRY_CODE&quot;]&nbsp;is assigned to you.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


SET SQL_SAFE_UPDATES = 1;
